% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-helpers.R
\name{jlme-model-helpers}
\alias{jlme-model-helpers}
\alias{propertynames}
\alias{issingular}
\title{Helpers for interacting with Julia model objects and functions}
\usage{
propertynames(x)

issingular(x)
}
\arguments{
\item{x}{Julia model object}
}
\value{
An appropriate R object
}
\description{
Helpers for interacting with Julia model objects and functions
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
jlme_setup(restart = TRUE)

x <- jlmer(r2 ~ Anger + (1 | id), lme4::VerbAgg, family = "binomial")

# `propertynames()` lists properties accessible via `$`
propertynames(x)

# `issingular()` reports whether model has singular fit
issingular(x)

stop_julia()
}
\dontshow{\}) # examplesIf}
}
