% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoImage.R
\name{annoImage}
\alias{annoImage}
\title{annoImage}
\usage{
annoImage(
  object = NULL,
  relSideDist = 0.1,
  annoPos = "top",
  xPosition = NULL,
  yPosition = NULL,
  images = NULL,
  segWidth = 1,
  annoManual = FALSE,
  imgWidth = 1,
  imgHeight = 1
)
}
\arguments{
\item{object}{This function is used to add segment annotations in plot.}

\item{relSideDist}{The relative distance ratio to the y axis range. Default(0.1).}

\item{annoPos}{The position for the annotation to be added. Default("top").}

\item{xPosition}{The x axis coordinate for the image. Default(NULL).}

\item{yPosition}{The y axis coordinate for the image. Default(NULL).}

\item{images}{The images paths. Default(NULL).}

\item{segWidth}{The relative image width. Default(1).}

\item{annoManual}{Whether annotate by yourself by supplying with x and y coordinates. Default(FALSE).}

\item{imgWidth}{The image width. Default(1).}

\item{imgHeight}{The image height. Default(1).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add image annotations in plot.
}
\examples{
# ===============================
# test function

\donttest{ # load data
data(p)

img1 <- system.file("extdata/animal-img/", "1.jpg", package = "jjAnno")
img2 <- system.file("extdata/animal-img/", "2.jpg", package = "jjAnno")
img3 <- system.file("extdata/animal-img/", "3.jpg", package = "jjAnno")
img4 <- system.file("extdata/animal-img/", "4.jpg", package = "jjAnno")
img5 <- system.file("extdata/animal-img/", "5.jpg", package = "jjAnno")
img6 <- system.file("extdata/animal-img/", "6.jpg", package = "jjAnno")
img7 <- system.file("extdata/animal-img/", "7.jpg", package = "jjAnno")
img8 <- system.file("extdata/animal-img/", "8.jpg", package = "jjAnno")
img9 <- system.file("extdata/animal-img/", "9.jpg", package = "jjAnno")
img10 <- system.file("extdata/animal-img/", "10.jpg", package = "jjAnno")

imgs <- c(img1,img2,img3,img4,img5,img6,img7,img8,img9,img10)


# add legend
annoImage(object = p,
          annoPos = 'top',
          xPosition = c(1:10),
          images = imgs,
          yPosition = c(11,12))

# change width
annoImage(object = p,
          annoPos = 'top',
          xPosition = c(1:10),
          images = imgs,
          yPosition = c(11,11.8),
          segWidth = 0.8)

# add to right
annoImage(object = p,
          annoPos = 'right',
          yPosition = c(1:10),
          images = imgs,
          xPosition = c(11,11.8),
          segWidth = 0.8)
}
}
\author{
Junjun Lao
}
