% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jack.R
\name{JackR}
\alias{JackR}
\title{Evaluation of Jack polynomials}
\usage{
JackR(x, lambda, alpha, algorithm = "DK")
}
\arguments{
\item{x}{numeric or complex vector or \code{\link[gmp]{bigq}} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{alpha}{ordinary number or \code{bigq} rational number}

\item{algorithm}{the algorithm used, either \code{"DK"} (Demmel-Koev)
or \code{"naive"}}
}
\value{
A numeric or complex scalar or a \code{bigq} rational number.
}
\description{
Evaluates a Jack polynomial.
}
\examples{
lambda <- c(2,1,1)
JackR(c(1/2, 2/3, 1), lambda, alpha = 3)
# exact value:
JackR(c(gmp::as.bigq(1,2), gmp::as.bigq(2,3), gmp::as.bigq(1)), lambda,
     alpha = gmp::as.bigq(3))
}
\references{
\itemize{
\item I.G. Macdonald.
\emph{Symmetric Functions and Hall Polynomials}.
Oxford Mathematical Monographs.
The Clarendon Press Oxford University Press,
New York, second edition, 1995.
\item J. Demmel & P. Koev.
\emph{Accurate and efficient evaluation of Schur and Jack functions}.
Mathematics of computations, vol. 75, n. 253, 223-229, 2005.
\item \emph{Jack polynomials}.
\url{https://www.symmetricfunctions.com/jack.htm}
}
}
\seealso{
\code{\link{JackPolR}}
}
