% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irg.R
\name{calc_irg}
\alias{calc_irg}
\title{IRG}
\usage{
calc_irg(DT, id = "id", year = "yr", scaled = TRUE)
}
\arguments{
\item{DT}{data.table of model parameters (output from model_params).}

\item{id}{id column. default is 'id'. See details.}

\item{year}{year column name. default is 'yr'.}

\item{scaled}{boolean indicating if irg should be rescaled between 0-1 within id and year. If TRUE, provide id and year. Default is TRUE.}
}
\value{
Extended data.table 'irg' column of instantaneous rate of green-up calculated for each day of the year, for each individual and year.
}
\description{
Calculate the instantaneous rate of green-up.
}
\details{
The DT argument expects a data.table of model estimated parameters for double logistic function of NDVI for each year and individual. Since it is the rate of green-up, model parameters required are only xmidS and scalS.

The scaled argument is used to optionally rescale the IRG result to 0-1, for each year and individual.

The id argument is used to split between sampling units. This may be a point id, polygon id, pixel id, etc. depending on your analysis. This should match the id provided to filtering functions.
The formula used is described in Bischoff et al. (2012):

\deqn{IRG = (exp((t + xmidS) / scalS)) / (2 * scalS * (exp(1) ^ ((t + xmidS) / scalS)) + (scalS * (exp(1) ^ ((2 * t) / scalS))) + (scalS * exp(1) ^ ((2 * xmidS) / scalS)))}

(See the "Getting started with irg vignette" for a better formatted formula.)
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

# Filter and scale NDVI time series
filter_ndvi(ndvi)
scale_doy(ndvi)
scale_ndvi(ndvi)

# Guess starting parameters
model_start(ndvi)

# Double logistic model parameters given starting parameters for nls
mods <- model_params(
  ndvi,
  return = 'models',
  xmidS = 'xmidS_start',
  xmidA = 'xmidA_start',
  scalS = 0.05,
  scalA = 0.01
)

# Fit double logistic curve to NDVI time series
fit <- model_ndvi(mods, observed = FALSE)

# Calculate IRG for each day of the year
calc_irg(fit)
}
\seealso{
Other irg: 
\code{\link{irg}()}
}
\concept{irg}
