% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_experiments_matrix.R
\name{plot_experiments_matrix}
\alias{plot_experiments_matrix}
\title{Heat Map Plot}
\usage{
plot_experiments_matrix(
  experiments,
  filename = NULL,
  metric = c("raw", "rpd", "rank"),
  show_conf_ids = FALSE,
  interactive = base::interactive()
)
}
\arguments{
\item{experiments}{\code{matrix()}\cr Experiment matrix obtained from irace
training or testing data. Configurations in columns and instances in
rows. As in irace, column names (configurations IDs) should be characters.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}

\item{metric}{Cost metric shown in the plot: \code{"raw"} shows the raw
values, \code{"rpd"} shows relative percentage deviation per instance and
\code{"rank"} shows rank per instance.}

\item{show_conf_ids}{(\code{logical(1)})\cr  If \code{TRUE}, it shows the configuration IDs in the x-axis. The default \code{NA},
only shows them if there are no more than 25.}

\item{interactive}{(\code{logical(1)}) TRUE if the report may use interactive features (using \code{\link[plotly:ggplotly]{plotly::ggplotly()}}, \code{\link[plotly:plot_ly]{plotly::plot_ly()}} and \code{\link[DT:dataTableOutput]{DT::renderDataTable()}}) or FALSE if such features must be disabled. Defaults to the value returned by \code{interactive()},}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Creates a heatmap plot that shows all performance data seen by irace.
Configurations are shown in the x-axis in the order in which they are
created in the configuration process. Instances are shown in the y-axis in
the order in which they where seen during the configuration run. This plot
gives a general idea of the configuration process progression, the number of
evaluations of each configuration show how long they survived in the
iterated racing procedure.  Rejected configurations are shown with a red \code{X}.
}
\note{
Alternatively, \code{experiments} could be the data generated when loading the
\code{.Rdata} file created by \code{irace} (or the filename of that file), from which
the experiments matrix will be loaded.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
plot_experiments_matrix(iraceResults)

plot_experiments_matrix(read_logfile(system.file(package="iraceplot", "exdata",
                                         "dummy-reject.Rdata", mustWork = TRUE)))
}
