% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_targetzone.R
\name{get_targetzone}
\alias{get_targetzone}
\title{get a targeted zone}
\usage{
get_targetzone(targ.min = c(50, 9), targ.max = c(200, 11), feat = NULL,
  min.points = 100, max.points = 150)
}
\arguments{
\item{targ.min}{is a d-dimensional vector of minimum values delimiting the targeted space, where d is the number of properties.}

\item{targ.max}{is a d-dimensional vector of maximum values delimiting the targeted space, where d is the number of properties.}

\item{feat}{is a n rows x d columns matrix, where d and n are the number of properties and datapoints respectively.}

\item{min.points}{minimum number of points required in the targeted space of properties.}

\item{max.points}{maximum number of points required in the targeted space of properties.}
}
\value{
the boundaries of a targeted zone.
}
\description{
Get a temporary targeted space of properties (a.k.a physico-chemical properties here) to populate.
This space can be on the path to reach the final desired target, or the final targeted space by itself. This depends on
how the temporary targeted space fits the population of observables constrains delimited by the parameters min.points and
max.points described below.
}
\examples{
\dontrun{data(qspr.data)
ty <- as.matrix(qspr.data[,c(2,5)])
targ.zone <- get_targetzone(targ.min=c(50,9),targ.max=c(200,11),
                             feat=ty,
                             min.points=100,max.points=150)}

}
