% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_smiles.R
\name{get_smiles}
\alias{get_smiles}
\title{get SMILES strings from the SmcChem object}
\usage{
get_smiles(smchem)
}
\arguments{
\item{smchem}{SmcChem class object}
}
\description{
get SMILES strings from the SmcChem object
}
\examples{
data(engram_5k) 
data(qsprpred_EG_5k)
smchem <- SmcChem$new(smis = rep("c1ccccc1O", 25), v_qsprpred=qsprpred_EG_5k,
                     v_engram=engram_5k,temp=3)
smcexec(smchem, niter=5, preorder=0, nview=4)
get_smiles(smchem)

}

