% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{optim_est}
\alias{optim_est}
\title{One-step update for obtaining estimator}
\usage{
optim_est(
  X_lab,
  X_unlab,
  Y_lab,
  Yhat_lab,
  Yhat_unlab,
  w,
  theta,
  quant = NA,
  method
)
}
\arguments{
\item{X_lab}{Array or data.frame containing observed covariates in
labeled data.}

\item{X_unlab}{Array or data.frame containing observed or
predicted covariates in unlabeled data.}

\item{Y_lab}{Array or data.frame of observed outcomes in labeled data.}

\item{Yhat_lab}{Array or data.frame of predicted outcomes in labeled data.}

\item{Yhat_unlab}{Array or data.frame of predicted outcomes in
unlabeled data.}

\item{w}{weights vector PSPA linear regression (d-dimensional, where
d equals the number of covariates).}

\item{theta}{parameter theta}

\item{quant}{quantile for quantile estimation}

\item{method}{indicates the method to be used for M-estimation.
Options include "mean", "quantile", "ols", "logistic", and "poisson".}
}
\value{
estimator
}
\description{
\code{optim_est} function for One-step update for obtaining estimator
}
