% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericfunctions.R
\name{plot.invacost.costmodel}
\alias{plot.invacost.costmodel}
\title{Plot model predictions of cost trends over time}
\usage{
\method{plot}{invacost.costmodel}(
  x,
  plot.breaks = 10^(-15:15),
  plot.type = "facets",
  models = c("ols.linear", "ols.quadratic", "robust.linear", "robust.quadratic", "gam",
    "mars", "quantile"),
  graphical.parameters = NULL,
  ...
)
}
\arguments{
\item{x}{The output object from \code{\link{modelCosts}}}

\item{plot.breaks}{a vector of numeric values indicating the plot breaks 
for the Y axis (cost values)}

\item{plot.type}{\code{"single"} or \code{"facets"}. Defines the type of plot
you want to make: a single facet with all models (\code{"single"}), or a 
facet per category of model (\code{"facets"})}

\item{models}{the models the user would like to appear in the plots. Can be
any subset of the models included in 'modelCosts'. Default is all models.}

\item{graphical.parameters}{set this to \code{"manual"} if you want to 
customise \code{ggplot2} parameters. 
By default, the following layers are configured: \code{ylab}, \code{xlab}, 
\code{scale_x_continuous},
\code{theme_bw} and, if \code{cost.transf = "log10"}, \code{scale_y_log10} and 
\code{annotation_logticks}. If you specify \code{grahical.parameters = "manual"},
all defaults will be ignored.}

\item{...}{additional arguments, none implemented for now}
}
\description{
This function provides different plotting methods for the estimated annual
cost of invasive species based on the temporal trend of costs.
}
\note{
Error bands represent 95% confidence intervals for OLS regression, robust
regression, GAM and quantile regression. We cannot construct confidence 
intervals around the mean for MARS techniques. However, we can estimate
prediction intervals by fitting a variance model to MARS residuals. Hence,
the error bands for MARS model represent 95% prediction intervals estimated
by fitting a linear model to the residuals of the MARS model. To learn more
about this, see \code{\link[earth]{varmod}}


If the legend appears empty (no colours) on your computer screen, try to
zoom in the plot, or to write to a file. There is a rare bug where under
certain conditions you cannot see the colours in the legend, because of their
transparency; zooming in or writing to a file are the best workarounds.
}
\examples{
data(invacost)

### Cleaning steps
# Eliminating data with no information on starting and ending years
invacost <- invacost[-which(is.na(invacost$Probable_starting_year_adjusted)), ]
invacost <- invacost[-which(is.na(invacost$Probable_ending_year_adjusted)), ]
# Keeping only observed and reliable costs
invacost <- invacost[invacost$Implementation == "Observed", ]
invacost <- invacost[which(invacost$Method_reliability == "High"), ]
# Eliminating data with no usable cost value
invacost <- invacost[-which(is.na(invacost$Cost_estimate_per_year_2017_USD_exchange_rate)), ]

### Expansion
\donttest{
db.over.time <- expandYearlyCosts(invacost,
                                  startcolumn = "Probable_starting_year_adjusted",
                                  endcolumn = "Probable_ending_year_adjusted")

### Analysis
res <- modelCosts(db.over.time)

### Visualisation
plot(res)
plot(res, plot.type = "single")}
}
\references{
\url{https://github.com/Farewe/invacost}

Leroy Boris, Kramer Andrew M, Vaissière Anne-Charlotte, Courchamp Franck & 
Diagne Christophe (2020). Analysing global economic costs of invasive alien 
species with the
invacost R package. biorXiv. \url{https://doi.org/10.1101/2020.12.10.419432}
}
