% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateRawCosts.R
\name{calculateRawAvgCosts-deprecated}
\alias{calculateRawAvgCosts-deprecated}
\title{Calculate the raw average annual cost of invasions over periods of time}
\usage{
calculateRawAvgCosts(
  costdb,
  cost.column = "Cost_estimate_per_year_2017_USD_exchange_rate",
  year.column = "Impact_year",
  in.millions = TRUE,
  minimum.year = 1960,
  maximum.year = 2017,
  year.breaks = seq(minimum.year, maximum.year, by = 10),
  include.last.year = TRUE
)
}
\arguments{
\item{costdb}{The \bold{expanded INVACOST database} output from 
\code{\link{expandYearlyCosts}},
where annual costs occurring over several years are repeated for each year.}

\item{cost.column}{Name of the cost column to use in \code{costdb} (usually, 
choose between the exchange rate (default) or PPP annualised cost)}

\item{year.column}{Name of the year column to use in \code{costdb}( usually, 
"Impact_year" from \code{\link{expandYearlyCosts}}}

\item{in.millions}{If \code{TRUE}, cost values will be transformed in 
millions (to make graphs easier to read), else if \code{}, cost values will
not be transformed.}

\item{minimum.year}{the starting year of this analysis. By default, 
1960 was chosen because it marks the period from which world bank data is 
available for exchange rates and inflation values.}

\item{maximum.year}{the ending year for this analysis. By default, 2017
was chosen as it is the last year for which we have data in INVACOST.}

\item{year.breaks}{a vector of breaks for the year intervals over which
you want to calculate raw cost values}

\item{include.last.year}{\code{TRUE} or \code{FALSE}. Defines if the last
year of the dataset is included in the last interval (\code{TRUE}) or is
considered as an interval of its own (\code{FALSE}). Generally only useful
if the last year is at the limit of an interval.}
}
\value{
a \code{list} with 6 elements:

\itemize{
\item{\code{cost.data}: the input data.}
\item{\code{parameters}: parameters used to run the function. The 
\code{minimum.year} and \code{maximum.year} are based on the input data
(i.e., the user may specify \code{minimum.year = 1960} but the input data may
only have data starting from 1970, hence the \code{minimum.year} will be
 1970.)}
\item{\code{year.breaks}: the years used to define year intervals over which costs were calculated.}
\item{\code{cost.per.year}: the annualised costs of invasions, as sums of all 
costs for each year.}
\item{\code{average.total.cost}: the average annual cost of IAS calculated
over the entire time period}
\item{\code{average.cost.per.period}: a data.frame containing the the average 
annual cost of IAS calculated over each time interval}
}
The structure of this object can be seen using \code{str()}
}
\description{
This function calculates the raw average annual cost of invasive species
over different periods of time
}
\seealso{
\code{\link{invacost-deprecated}}
}
\keyword{internal}
