% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIA2csv.r
\name{IIA2csv}
\alias{IIA2csv}
\title{Output the result of Interval level intensity analysis as csv.}
\usage{
IIA2csv(IIA.output, time.points, filename)
}
\arguments{
\item{IIA.output}{Output list generated by \code{IIA} function.}

\item{time.points}{a charachter vector showing the time point of each raster layer in chronological order.}

\item{filename}{A charachter variable including an optional path and a required filename to where the user wants to store the csv output. If only the name of the file is provided, it will be stored in the working directory.}
}
\value{
The output is a CSV file.
}
\description{
Output the result of Interval level intensity analysis as csv.
}
\details{
Gets the output of \code{IIA} function and the path variable and generate a csv report called "IntervalLevelIntensityAnalysis.csv". The output will be stored in "CSVOutput" directory in path direction.
}
\examples{
raster_2005 <- raster::raster(system.file("external/RASTER_2005.RST", package="intensity.analysis"))
raster_2010 <- raster::raster(system.file("external/RASTER_2010.RST", package="intensity.analysis"))
raster_2012 <- raster::raster(system.file("external/RASTER_2012.RST", package="intensity.analysis"))
raster.layers <- list(raster_2005, raster_2010, raster_2012)
time.points <- c("2005","2010","2012")
categories <- c("Water","Trees","Impervious")
crosstabulation <- multicrosstab(raster.layers, time.points, categories)
IIA.output <- IIA(crosstabulation, time.points)
filename <- file.path(normalizePath(tempdir(), winslash = "/"), "IIA.csv")
IIA2csv(IIA.output,time.points, filename)
}
