% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doMatch.R
\name{doMatch}
\alias{doMatch}
\title{Match the RNA-Seq and ChIP-Seq data on the gene level}
\usage{
doMatch(rnaMeta, chipMeta, region, method, ensemblDataset,
  fragLength = 180, promoter.length = 5000)
}
\arguments{
\item{rnaMeta}{metadata for RNA-Seq include column named "condition" indicates the
experiment condition or cell type, and column named "files" indicates the
paths of cprresponing abundance.tsv file that is returned from Kallisto.}

\item{chipMeta}{metadata for ChIP-Seq include column of "mark" column indicates the markers
of histone modifications, column of "condition" indicates the experiment
condition or cell type, and "files" column indicates the paths and the file
names of the aligned bam files.}

\item{region}{region has to be specified as "promoter" or "genebody".}

\item{method}{method has to be specified as "weighted.mean" or"highest" if region is set as
"promoter".}

\item{ensemblDataset}{Ensembl Dataset you want to use. To see the different datasets available
within a biomaRt you can e.g. do: mart = useMart('ensembl'), followed by
listDatasets(mart).}

\item{fragLength}{extend reads toward the 3'-end to the average DNA fragment size obtained
after DNA size selection.}

\item{promoter.length}{the length of the promoter region.}
}
\value{
A list with the following three items.

res.rna
a data frame contains RNA-Seq counts

res.chip
a data frame contains ChIP-Seq counts

matched.data
a dataframe contains matched RNA-Seq counts and ChIP-Seq counts.
}
\description{
\code{doMatch} computes the number of reads (counts) fall into specific
genomic region such as promoter or genebody for ChIP-Seq, and calculate the
gene expression in counts, and then match the RNA-Seq and ChIP-Seq data on
the gene level with the method of "weighetd mean" or "highest".
}
\examples{
data(test_rna_meta)
data(test_chip_meta)
\donttest{
for(i in test_rna_meta$SRR){
test_rna_meta$files <- system.file("extdata",paste0(i,".tsv"),
package = "intePareto")
}
for(i in test_chip_meta$SRR){
test_chip_meta$files <- system.file("extdata", paste0(i,".bam"),
package = "intePareto")
}
doMatch(rnaMeta = test_rna_meta,
chipMeta = test_chip_meta,
region = "promoter",
method = "weighted.mean",
ensemblDataset = "mmusculus_gene_ensembl")
}
}
