% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam2rpm.R
\name{bam2rpm}
\alias{bam2rpm}
\title{Compute the normalized number of reads (rpm) fall into specific
genomic region}
\usage{
bam2rpm(bamFile, region, fragLength = 180)
}
\arguments{
\item{bamFile}{Aligned bam file as input.}

\item{region}{The GRanges object defined by user to calculate the number of reads fall into
this specific region. For ChIP-Seq of histone modifications they are usually
promoter, enhancer and genebody regions.}

\item{fragLength}{Extend reads toward the 3'-end to the average DNA fragment size obtained
after DNA size selection}
}
\value{
a vector of numbers
}
\description{
\code{bam2rpm} computes the normalized number of reads (rpm) fall into
specific genomic region such as promoter, enhancer, genebody
}
\examples{
data("promoter")
file.bam <- system.file("extdata", "SRR925640.bam", package = "intePareto")
bam2rpm(bamFile = file.bam, region = promoter, fragLength = 180)
}
