% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_predictors.R
\name{find_predictors}
\alias{find_predictors}
\alias{find_predictors.default}
\title{Find names of model predictors}
\usage{
find_predictors(x, ...)

\method{find_predictors}{default}(
  x,
  effects = "fixed",
  component = "all",
  flatten = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{effects}{Should variables for fixed effects (\code{"fixed"}), random effects
(\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed models. May
be abbreviated.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}

\item{verbose}{Toggle warnings.}
}
\value{
A list of character vectors that represent the name(s) of the
predictor variables. Depending on the combination of the arguments
\code{effects} and \code{component}, the returned list can have following elements:
\itemize{
\item \code{conditional}, the "fixed effects" terms from the model
\item \code{random}, the "random effects" terms from the model
\item \code{zero_inflated}, the "fixed effects" terms from the zero-inflation
component of the model. For models from \strong{brms}, this is named \code{zi}.
\item \code{zero_inflated_random}, the "random effects" terms from the zero-inflation
component of the model. For models from \strong{brms}, this is named \code{zi_random}.
\item \code{dispersion}, the dispersion terms
\item \code{instruments}, for fixed-effects regressions like \code{ivreg}, \code{felm} or \code{plm},
the instrumental variables
\item \code{correlation}, for models with correlation-component like \code{gls}, the
variables used to describe the correlation structure
\item \code{nonlinear}, for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), the staring estimates for the nonlinear parameters
\item \code{smooth_terms} returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms)
}
}
\description{
Returns the names of the predictor variables for the different
parts of a model (like fixed or random effects, zero-inflated component,
...). Unlike \code{\link[=find_parameters]{find_parameters()}}, the names from \code{find_predictors()} match
the original variable names from the data that was used to fit the model.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\section{Parameters, Variables, Predictors and Terms}{

There are four functions that return information about the variables in a
model: \code{find_predictors()}, \code{find_variables()}, \code{find_terms()} and
\code{find_parameters()}. There are some differences between those functions,
which are explained using following model. Note that some, but not all of
those functions return information about the \emph{dependent} and \emph{independent}
variables. In this example, we only show the differences for the independent
variables.

\if{html}{\out{<div class="sourceCode">}}\preformatted{model <- lm(mpg ~ factor(gear), data = mtcars)
}\if{html}{\out{</div>}}
\itemize{
\item \code{find_terms(model)} returns the model terms, i.e. how the variables were
used in the model, e.g. applying transformations like \code{factor()}, \code{poly()}
etc. \code{find_terms()} may return a variable name multiple times in case of
multiple transformations. The return value would be \code{"factor(gear)"}.
\item \code{find_parameters(model)} returns the names of the model parameters
(coefficients). The return value would be \code{"(Intercept)"}, \code{"factor(gear)4"}
and \code{"factor(gear)5"}.
\item \code{find_variables()} returns the original variable names. \code{find_variables()}
returns each variable name only once. The return value would be \code{"gear"}.
\item \code{find_predictors()} is comparable to \code{find_variables()} and also returns
the original variable names, but excluded the \emph{dependent} (response)
variables. The return value would be \code{"gear"}.
}
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_predictors(m)
}
