% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_varcov.R
\name{get_varcov}
\alias{get_varcov}
\alias{get_varcov.default}
\alias{get_varcov.glmgee}
\alias{get_varcov.hurdle}
\alias{get_varcov.aov}
\alias{get_varcov.mixor}
\title{Get variance-covariance matrix from models}
\usage{
get_varcov(x, ...)

\method{get_varcov}{default}(x, verbose = TRUE, vcov = NULL, vcov_args = NULL, ...)

\method{get_varcov}{glmgee}(x, verbose = TRUE, vcov = "robust", ...)

\method{get_varcov}{hurdle}(
  x,
  component = "conditional",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{get_varcov}{aov}(x, complete = FALSE, verbose = TRUE, ...)

\method{get_varcov}{mixor}(x, effects = "all", verbose = TRUE, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Currently not used.}

\item{verbose}{Toggle warnings.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance
matrix, a function which returns a covariance matrix, or a string which
identifies the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"},
\code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Cluster-robust: \code{"CR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"},
\code{"CR3"}. See \code{?clubSandwich::vcovCR}
\item Bootstrap: \code{"BS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"},
\code{"fractional"}, \code{"jackknife"}, \code{"norm"}, \code{"webb"}. See
\code{?sandwich::vcovBS}
\item Other \code{sandwich} package functions: \code{"HAC"}, \code{"PC"}, \code{"CL"}, \code{"OPG"},
\code{"PL"}.
\item Kenward-Roger approximation: \code{kenward-roger}. See \code{?pbkrtest::vcovAdj}.
}
}

One exception are models of class \code{glmgee}, which have pre-defined options
for the variance-covariance matrix calculation. These are \code{"robust"},
\code{"df-adjusted"}, \code{"model"}, \code{"bias-corrected"}, and \code{"jackknife"}. See
\code{?glmtoolbox::vcov.glmgee} for details.}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the
\strong{sandwich} or \strong{clubSandwich} packages. Please refer to their
documentation (e.g., \code{?sandwich::vcovHAC}) to see the list of available
arguments. If no estimation type (argument \code{type}) is given, the default
type for \code{"HC"} equals the default from the \strong{sandwich} package; for type
\code{"CR"}, the default is set to \code{"CR3"}.}

\item{component}{Should the complete variance-covariance matrix of the model
be returned, or only for specific model components only (like count or
zero-inflated model parts)? Applies to models with zero-inflated component,
or models with precision (e.g. \code{betareg}) component. \code{component} may be one
of \code{"conditional"}, \code{"zi"}, \code{"zero-inflated"}, \code{"dispersion"}, \code{"precision"},
or \code{"all"}. May be abbreviated. Note that the \emph{conditional} component also
refers to the \emph{count} or \emph{mean} component - names may differ, depending on
the modeling package. See section \emph{Model components} for details.}

\item{complete}{Logical, if \code{TRUE}, for \code{aov}, returns the full
variance-covariance matrix.}

\item{effects}{Should the complete variance-covariance matrix of the model
be returned, or only for specific model parameters only? Currently only
applies to models of class \code{mixor} and \code{MixMod}.}
}
\value{
The variance-covariance matrix, as \code{matrix}-object.
}
\description{
Returns the variance-covariance, as retrieved by \code{stats::vcov()}, but works
for more model objects that probably don't provide a \code{vcov()}-method.
}
\note{
\code{get_varcov()} tries to return the nearest positive definite matrix
in case of negative eigenvalues of the variance-covariance matrix. This
ensures that it is still possible, for instance, to calculate standard
errors of model parameters. A message is shown when the matrix is negative
definite and a corrected matrix is returned.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\examples{
\dontshow{if (require("pscl") && require("sandwich")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_varcov(m)

# vcov of zero-inflation component from hurdle-model
data("bioChemists", package = "pscl")
mod <- hurdle(art ~ phd + fem | ment, data = bioChemists, dist = "negbin")
get_varcov(mod, component = "zero_inflated")

# robust vcov of, count component from hurdle-model
data("bioChemists", package = "pscl")
mod <- hurdle(art ~ phd + fem | ment, data = bioChemists, dist = "negbin")
get_varcov(
  mod,
  component = "conditional",
  vcov = "BS",
  vcov_args = list(R = 50)
)
\dontshow{\}) # examplesIf}
}
