% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMap.R
\name{PlotMap}
\alias{PlotMap}
\title{Plot Method for Maps}
\usage{
PlotMap(r, layer = 1, att = NULL, n, breaks, xlim = NULL, ylim = NULL,
  zlim = NULL, asp = 1, extend.xy = FALSE, extend.z = FALSE,
  reg.axs = TRUE, trim.r = TRUE, dms.tick = FALSE, bg.lines = FALSE,
  bg.image = NULL, bg.image.alpha = 1, pal = NULL, col = NULL,
  max.dev.dim = c(43, 56), labels = NULL, scale.loc = "bottomleft",
  arrow.loc = NULL, explanation = NULL, credit = proj4string(r),
  shade = NULL, contour.lines = NULL, rivers = NULL, lakes = NULL,
  roads = NULL, draw.key = NULL, draw.raster = TRUE, useRaster)
}
\arguments{
\item{r}{RasterLayer, SpatialGridDataFrame, or CRS.
A raster layer with values to be plotted or a coordinate reference system (CRS).}

\item{layer}{integer.
Column to use in the SpatialGridDataFrame.}

\item{att}{numeric or character.
Variable identifying the levels attribute to use in the Raster Attribute Table (RAT).
This argument requires \code{r} values that are of class factor.}

\item{n}{integer.
Desired number of intervals to partition the range of raster values (or \code{zlim} if specified) (optional).}

\item{breaks}{numeric.
Vector of break points used to partition the colors representing numeric raster values (optional).}

\item{xlim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{x}-axis.}

\item{ylim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{y}-axis.}

\item{zlim}{numeric.
Vector of length 2 giving the minimum and maximum raster values for which colors should be plotted.}

\item{asp}{numeric.
The \emph{y/x} aspect ratio for spatial axes.}

\item{extend.xy}{logical.
If true, the spatial limits will be extended to the next tick mark on the axes beyond the grid extent.}

\item{extend.z}{logical.
If true, the raster value limits will be extended to the next tick mark on the color key beyond the measured range.}

\item{reg.axs}{logical.
If true, the spatial data range is extended.}

\item{trim.r}{logical.
If true, the outer rows and columns that consist of all NA values will be removed.}

\item{dms.tick}{logical.
If true, the axes tickmarks are specified in degrees, minutes, and decimal seconds.}

\item{bg.lines}{logical.
If true, the graticule is drawn in back of the raster layer using white lines and a grey background.}

\item{bg.image}{RasterLayer.
An image to drawn in back of the main raster layer \code{r}.}

\item{bg.image.alpha}{numeric.
Opacity of the background image from 0 to 1.}

\item{pal}{function.
Color palette to be used to assign colors in the plot, rainbow by default.}

\item{col}{character.
Vector of colors to be used in the plot.
This argument requires \code{breaks} specification for numeric values of \code{r} and
overrides any palette function specification.
For numeric values there should be one less color than breaks.
Factors require a color for each level.}

\item{max.dev.dim}{numeric.
Vector of length 2 giving the maximum width and height for the graphics device in picas, respectively.
Suggested dimensions for single-column, double-column, and sidetitle figures are
\code{c(21, 56)}, \code{c(43, 56)}, and \code{c(56, 43)}, respectively.}

\item{labels}{list.
Describes the location and values of labels in the color key.
This list may include components \code{at} and \code{labels}.}

\item{scale.loc}{character.
Position of the scale bar:
"bottomleft", "topleft", "topright", or "bottomright" to denote scale location.}

\item{arrow.loc}{character.
Position of the north arrow:
"bottomleft", "topleft", "topright", or "bottomright" to denote arrow location.}

\item{explanation}{character.
Label explaining the raster value.}

\item{credit}{character.
Label crediting the base map.}

\item{shade}{list.
If specified, a semi-transparent shade layer is drawn on top of the raster layer.
This layer is described using a list of arguments supplied to \code{raster::hillShade} function.
Passed arguments include \code{"angle"} and \code{"direction"}.
Additional arguments also may be passed that control the vertical aspect ratio
(\code{"z.factor"}) and color opacity (\code{"alpha"}).}

\item{contour.lines}{list.
If specified, contour lines are drawn.
The contours are described using a list of arguments supplied to \code{contour}.
Passed arguments include \code{"drawlables"}, \code{"method"}, and \code{"col"}.}

\item{rivers}{list.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for SpatialLines.
Passed arguments include \code{"x"}, \code{"col"}, and \code{"lwd"}.}

\item{lakes}{list.
If specified, polygons are drawn.
The polygons are described using a list of arguments supplied to the plot method for SpatialPolygons.
Passed arguments include \code{"x"}, \code{"col"}, \code{"border"}, and \code{"lwd"}.
Bitmap images require a regular grid.}

\item{roads}{list.
If specified, lines are drawn.
The lines are described using a list of arguments supplied to the plot method for SpatialLines.
Passed arguments include \code{"x"}, \code{"col"}, and \code{"lwd"}.}

\item{draw.key}{logical.
If true, a color key should be drawn.}

\item{draw.raster}{logical.
If true, the raster image is drawn.}

\item{useRaster}{logical.
If true, a bitmap raster is used to plot \code{r} instead of using polygons.
If \code{UseRaster} is not specified, raster images are used when the \code{getOption("preferRaster")} is true.}
}
\value{
Used for the side-effect of a new plot generated.
  Returns a \code{list} object with the following graphical parameters:
  \describe{
    \item{din}{device dimensions \code{(width, height)}, in inches.}
    \item{usr}{extremes of the coordinates of the plotting region \code{(x1, x2, y1, y2)}.}
    \item{heights}{relative heights on the device \code{(upper, lower)} for the map and color-key plots.}
  }
}
\description{
This function maps raster layer values.
A key showing how the colors map to raster values is shown below the map.
}
\details{
The dimensions of a new graphics device is dependent on the argument values of \code{max.dev.dim} and \code{asp}.
}
\examples{
library(raster)

r <- raster(nrow = 10, ncol = 10)
r[] <- 1L
r[51:100] <- 2L
r[3:6, 1:5] <- 8L
r <- ratify(r)
rat <- levels(r)[[1]]
rat$land.cover <- c("Pine", "Oak", "Meadow")
rat$code <- c(12, 25, 30)
levels(r) <- rat
PlotMap(r, att = "land.cover", col = c("grey", "orange", "purple"))
PlotMap(r, att = "code")

graphics.off()
r <- raster(system.file("external/test.grd", package="raster"))
PlotMap(r, scale.loc = "topleft", dms.tick = TRUE, trim.r = TRUE)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\seealso{
\code{\link{AddScaleBar}}, \code{\link{AddColorKey}}
}
\keyword{hplot}

