% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_feature_importance.R
\name{print.feature_importance_explainer}
\alias{print.feature_importance_explainer}
\title{Print Generic for Feature Importance Object}
\usage{
\method{print}{feature_importance_explainer}(x, ...)
}
\arguments{
\item{x}{an explanation created with \code{\link{feature_importance}}}

\item{...}{other parameters.}
}
\value{
a data frame.
}
\description{
Print Generic for Feature Importance Object
}
\examples{
library("DALEX")
library("ingredients")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8],
                               verbose = FALSE)

fi_glm <- feature_importance(explain_titanic_glm)

fi_glm


}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{http://ema.drwhy.ai}
}
