% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_importance.R
\name{plot.feature_importance_explainer}
\alias{plot.feature_importance_explainer}
\title{Plots Feature Importance}
\usage{
\method{plot}{feature_importance_explainer}(
  x,
  ...,
  max_vars = NULL,
  show_boxplots = TRUE,
  bar_width = 10,
  desc_sorting = TRUE,
  title = "Feature Importance",
  subtitle = NA
)
}
\arguments{
\item{x}{a feature importance explainer produced with the \code{feature_importance()} function}

\item{...}{other explainers that shall be plotted together}

\item{max_vars}{maximum number of variables that shall be presented for for each model.
By default \code{NULL} what means all variables}

\item{show_boxplots}{logical if \code{TRUE} (default) boxplot will be plotted to show permutation data.}

\item{bar_width}{width of bars. By default \code{10}}

\item{desc_sorting}{logical. Should the bars be sorted descending? By default TRUE}

\item{title}{the plot's title, by default \code{'Feature Importance'}}

\item{subtitle}{the plot's subtitle. By default - NA, which means
the subtitle will be 'created for the XXX model', where XXX is the label of explainer(s)}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots variable importance calculated as changes in the loss function after variable drops.
It uses output from \code{feature_importance} function that corresponds to
permutation based measure of variable importance.
Variables are sorted in the same order in all panels.
The order depends on the average drop out loss.
In different panels variable contributions may not look like sorted if variable
importance is different in different in different models.
}
\details{
Find more details in the \href{https://pbiecek.github.io/ema/featureImportance.html}{Feature Importance Chapter}.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

fi_rf <- feature_importance(explain_titanic_glm)
plot(fi_rf)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8])

fi_rf <- feature_importance(explain_titanic_rf)
plot(fi_rf)

HR_rf_model <- randomForest(status~., data = HR, ntree = 100)

explainer_rf  <- explain(HR_rf_model, data = HR, y = HR$status,
                         verbose = FALSE, precalculate = FALSE)

fi_rf <- feature_importance(explainer_rf, type = "raw", max_vars = 3,
                            loss_function = loss_cross_entropy)
head(fi_rf)
plot(fi_rf)

HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR, y = HR$status == "fired")

fi_glm <- feature_importance(explainer_glm, type = "raw",
                             loss_function = loss_root_mean_square)
head(fi_glm)
plot(fi_glm)

}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
