% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_regression.R
\name{single_network}
\alias{single_network}
\title{Construct network for single target gene}
\usage{
single_network(
  matrix,
  regulators,
  target,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  algorithm = "CD",
  regulators_num = (ncol(matrix) - 1),
  n_folds = 10,
  percent_samples = 1,
  r_threshold = 0,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{matrix}{An expression matrix.}

\item{regulators}{The regulator genes for which to infer the regulatory network.}

\item{target}{The target gene.}

\item{cross_validation}{Logical value, default is \emph{\code{FALSE}}, whether to use cross-validation.}

\item{seed}{The random seed for cross-validation, default is \emph{\code{1}}.}

\item{penalty}{The type of regularization, default is \emph{\code{L0}}.
This can take either one of the following choices: \emph{\code{L0}}, \emph{\code{L0L1}}, and \emph{\code{L0L2}}.
For high-dimensional and sparse data, \emph{\code{L0L2}} is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function, default is \emph{\code{CD}}.
Currently \emph{\code{CD}} and \emph{\code{CDPSI}} are supported.
The \emph{\code{CDPSI}} algorithm may yield better results, but it also increases running time.}

\item{regulators_num}{The number of non-zore coefficients, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{n_folds}{The number of folds for cross-validation, default is \emph{\code{10}}.}

\item{percent_samples}{The percent of all samples used for \code{\link{sparse_regression}}, default is \emph{\code{1}}.}

\item{r_threshold}{Threshold of \eqn{R^2} or correlation coefficient, default is \emph{\code{0}}.}

\item{verbose}{Logical value, default is \emph{\code{TRUE}}, whether to print progress messages.}

\item{...}{Parameters for other methods.}
}
\value{
The weight data table of sub-network
}
\description{
Construct network for single target gene
}
\examples{
data("example_matrix")
head(
  single_network(
    example_matrix,
    regulators = colnames(example_matrix),
    target = "g1"
  )
)

single_network(
  example_matrix,
  regulators = "g1",
  target = "g2"
)
}
