% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_filter.R
\name{weight_filter}
\alias{weight_filter}
\title{weight_filter}
\usage{
weight_filter(weight_table, method = "max")
}
\arguments{
\item{weight_table}{weight_table}

\item{method}{method}
}
\value{
Filtered weight table
}
\description{
weight_filter
}
\examples{
library(inferCSN)
data("example_matrix")
data("example_ground_truth")
weight_table <- inferCSN(example_matrix, verbose = TRUE)
weight_table_new <- weight_filter(weight_table)
network.heatmap(
  example_ground_truth[, 1:3],
  heatmap_title = "Ground truth",
  show_names = TRUE,
  rect_color = "gray90"
)
network.heatmap(
  weight_table,
  heatmap_title = "Raw",
  show_names = TRUE,
  rect_color = "gray90"
)
network.heatmap(
  weight_table_new,
  heatmap_title = "Filtered",
  show_names = TRUE,
  rect_color = "gray90"
)

auc.calculate(
  weight_table,
  example_ground_truth,
  plot = TRUE
 )
auc.calculate(
  weight_table_new,
  example_ground_truth,
  plot = TRUE
 )
}
