% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidentally.R
\docType{package}
\name{incidentally}
\alias{incidentally}
\alias{incidentally-package}
\title{incidentally: Generates incidence matrices and bipartite graphs}
\description{
Functions to generate incidence matrices and bipartite graphs that have
(1) a fixed fill rate, (2) given marginal sums, (3) marginal sums that follow given
distributions, or (4) represent bill sponsorships in the US Congress. It can also
generate an incidence matrix from an adjacency matrix, or bipartite graph from a
unipartite graph, via a social process mirroring team, group, or organization formation.

Incidence matrices can be generated:
\itemize{
\item ...with a fixed fill rate: \code{\link[=incidence.from.probability]{incidence.from.probability()}}.
\item ...with given marginals: \code{\link[=incidence.from.vector]{incidence.from.vector()}}.
\item ...with marginals that follow given distributions: \code{\link[=incidence.from.distribution]{incidence.from.distribution()}}.
\item ...from a network, by a social process mirroring team, group, or organization formation \code{\link[=incidence.from.adjacency]{incidence.from.adjacency()}}.
\item ...with a block structure or planted partition: \code{\link[=add.blocks]{add.blocks()}}.
\item ...from US Congress bill sponsorships: \code{\link[=incidence.from.congress]{incidence.from.congress()}}.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.zacharyneal.com/backbone}
  \item \url{https://github.com/zpneal/incidentally}
  \item Report bugs at \url{https://github.com/zpneal/incidentally/issues}
}

}
\author{
\strong{Maintainer}: Zachary Neal \email{zpneal@msu.edu} (\href{https://orcid.org/0000-0003-3076-4995}{ORCID})

}
