% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.incalogical.R
\name{is.incalogical}
\alias{is.incalogical}
\alias{incalogical2logical}
\title{Coerce to logical if value is logical according to INCA}
\usage{
is.incalogical(x)

incalogical2logical(x)
}
\arguments{
\item{x}{vector (potentially logical)}
}
\value{
\code{is.incalogical} returns \code{TRUE} if the vector 
is logical according to INCA:s internal rules, \code{FALSE} otherwise.
\code{incalogical2logical} returns a logical vector if \code{x} 
can be coerced to such.
}
\description{
Boolean vectors in INCA are stored internally as 0/1 and are changed to 
"True"/blank when exported. These functions identify such a variable as 
Boolean and can coerce it to such.
}
\details{
It is common that check boxes are blanks by default but that this should 
be interpreted as \code{TRUE}. There are however some uncommon cases
were the boxes are marked with "False" for \code{FALSE}. 
We can therefore not be certain of the meaning of a blank value. 
These will therefore be treated as \code{NA}.
}
\examples{
is.incalogical(c("", "", "True", ""))  # TRUE
is.incalogical(c("", "False", "", "")) # TRUE
is.incalogical(c("", "FALSE", "", "")) # FALSE
is.incalogical(logical(2)) # will be recognised as well
}
