% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMLH.R
\name{MLH}
\alias{MLH}
\title{Calculate multilocus heterozygosity (MLH)}
\usage{
MLH(genotypes)
}
\arguments{
\item{genotypes}{data.frame with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and NA (missing)}
}
\value{
Vector of individual multilocus heterozygosities
}
\description{
MLH is defined as the total number of heterozygous loci in an individual divided 
by the number of loci typed in the focal individual. An MLH of 0.5 thus means
that 50 percent of an indiviudals loci are heterozygous.
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
het <- MLH(genotypes)

}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
\references{
Coltman, D. W., Pilkington, J. G., Smith, J. A., & Pemberton, J. M. (1999). 
Parasite-mediated selection against inbred Soay sheep in a free-living, 
island population. Evolution, 1259-1267.
}

