% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.remove.R
\name{na.remove}
\alias{na.remove}
\title{Remove Missing Values}
\usage{
na.remove(x)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Removes all missing values from a time series.
}
\details{
Removes all missing values from a time series. This shortens the time series by
the number of missing values in the series. Should be handled with care, because this can affect
the seasonality of the time series. Seasonal patterns might be destroyed and/or frequency parameter of the 
ts object might be no more correct.
}
\examples{
#Example 1: Remove all NAs
#Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))
#Remove all NAs
na.remove(x)


#Example 2: Remove all NAs in tsAirgap
na.remove(tsAirgap)

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}

