% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkImprecision}
\alias{checkImprecision}
\title{Imprecise Imputation}
\usage{
checkImprecision(data)
}
\arguments{
\item{data}{data.frame to test to apply the check onto.}
}
\value{
A named logical vector of length \code{ncol(data)},
where \code{TRUE} indicates that \code{"|"} is present in the
values, which is used to indicate an imprecise observations.
}
\description{
Check whether the variables of a data frame
contain imprecise observations
}
\note{
This check is only reliabe for \code{data}, inheriting
class \code{"impimp"}. If \code{data} does not inherit class
\code{"impimp"}, the check is tried, but additionaly the
user is notified with a warning.
}
\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
AimpB <- impimp(A, B, method = "variable_wise")
BimpA <- impimp(B, A, method = "variable_wise")
AB <- rbindimpimp(AimpB, BimpA)
checkImprecision(AB)

\donttest{
data(iris)
checkImprecision(iris) # emits a warning
}
}
\seealso{
\code{\link{impimp}}
}
