% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensions.R
\name{immunr_pca}
\alias{immunr_pca}
\alias{immunr_mds}
\alias{immunr_tsne}
\title{Dimensionality reduction}
\usage{
immunr_pca(.data, .scale = default_scale_fun, .raw = TRUE, .orig = FALSE, .dist = FALSE)

immunr_mds(.data, .scale = default_scale_fun, .raw = TRUE, .orig = FALSE, .dist = TRUE)

immunr_tsne(.data, .perp = 1, .dist = TRUE, ...)
}
\arguments{
\item{.data}{A matrix or a data frame with features, distance matrix or output from \link{repOverlapAnalysis} or \link{geneUsageAnalysis} functions.}

\item{.scale}{A function to apply to your data before passing it to any of
dimensionality reduction algorithms. There is no scaling by default.}

\item{.raw}{If TRUE then returns the non-processed output from dimensionality reduction
algorithms. Pass FALSE if you want to visualise results.}

\item{.orig}{If TRUE then returns the original result from algorithms. Pass FALSE
if you want to visualise results.}

\item{.dist}{If TRUE then assumes that ".data" is a distance matrix.}

\item{.perp}{The perplexity parameter for \link[Rtsne]{Rtsne}. Sepcifies the number
of neighbours each data point must have in the resulting plot.}

\item{...}{Other parameters passed to \link[Rtsne]{Rtsne}.}
}
\value{
\code{immunr_pca} - an output from \link{prcomp}.

\code{immunr_mds} - an output from \link{isoMDS}.

\code{immunr_tsne} - an output from \link{Rtsne}.
}
\description{
Collects a set of principal variables, reducing the number of not important variables
to analyse. Dimensionality reduction makes data analysis algorithms work faster and
sometimes more accurate, since it also reduces noise in the data. Currently available
methods are:

- \code{immunr_pca} performs PCA (Principal Component Analysis) using \link{prcomp};

- \code{immunr_mds} performs MDS (Multi-Dimensional Scaling) using \link[MASS]{isoMDS};

- \code{immunr_tsne} performs tSNE (t-Distributed Stochastic Neighbour Embedding) using \link[Rtsne]{Rtsne}.
}
\examples{
data(immdata)
gu <- geneUsage(immdata$data)
gu[is.na(gu)] <- 0
gu <- t(as.matrix(gu[, -1]))
immunr_pca(gu)
immunr_mds(dist(gu))
immunr_tsne(dist(gu))
}
\seealso{
\link{vis.immunr_pca} for visualisations.
}
\concept{post_analysis}
