% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{inc_overlap}
\alias{inc_overlap}
\title{Incremental counting of repertoire similarity}
\usage{
inc_overlap(
  .data,
  .fun,
  .step = 1000,
  .n.steps = 10,
  .downsample = FALSE,
  .bootstrap = NA,
  .verbose.inc = TRUE,
  ...
)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.fun}{Function to compute overlaps. e.g., \code{morisita_index}.}

\item{.step}{Either an integer or a numeric vector.

In the first case, the integer defines the step of incremental overlap.

In the second case, the vector encodes all repertoire sampling depths.}

\item{.n.steps}{Integer. Number of steps if \code{.step} is a single integer.
Skipped if ".step" is a numeric vector.}

\item{.downsample}{If TRUE then perform downsampling to N clonotypes at each step instead of choosing the
top N clonotypes.}

\item{.bootstrap}{Pass NA to turn off any bootstrapping, pass a number to perform bootstrapping with this number of tries.}

\item{.verbose.inc}{Logical. If TRUE then show output from the computation process.}

\item{...}{Other arguments passed to \code{.fun}.}
}
\value{
List with overlap matrices.
}
\description{
Like in paper https://www.pnas.org/content/111/16/5980 (Fig. 4).
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data, "inc+overlap", .step = 100, .verbose.inc = FALSE, .verbose = FALSE)
vis(ov)

}
\concept{overlap}
