% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{i_recode}
\alias{i_recode}
\title{i_recode
Function for recoding new variable from origin variable(s).}
\usage{
i_recode(
  x,
  ...,
  label = NULL,
  na_values = NULL,
  na_range = NULL,
  scale = NULL,
  copy = NULL
)
}
\arguments{
\item{x}{vector}

\item{...}{formula for recoding of values. See examples.}

\item{label}{variable label}

\item{na_values}{a vector with missing values}

\item{na_range}{a vector for missing range}

\item{scale}{scale level (nominal, ordinal, metric)}

\item{copy}{a variable from x. Copy the values of an existing variable before recoding values according to ...}
}
\value{
Returns i_labelled vector with values defined by formula and information given to function.
}
\description{
Returns a vector object of class i_labelled
}
\details{
Can be applied to either vector or data.frame. When x is data.frame the formula passed to ... is different from when it is applied to single vector.
When function is applied to a data.frame, multiple conditions on multiple variables are possible (e.g when variable X is equal to this, do that; when variable Y is not equal to this, do that, etc.). See examples for further clarification.

You can recode directly via value labels by using %in%.
}
\examples{
# When applied to a single vector:
# keep in mind that when function is applied to vector, instead of a column use x
myVector <- i_labelled(1:4, labels = c("A" = 1, "B" = 2, "C" = 3, "D" = 4))
i_recode(x = myVector, "AB" = 1 ~ x \%in\% c("A", "B"), "CD" = 2 ~ x == c(3, 4))

# When applied to data.frame (multiple conditions)
myData <- data.frame(
   V1 = i_labelled(1:3, labels = c("A" = 1, "B" = 2, "C" = 3)),
   V2 = i_labelled(c(2:3,-9))
)
i_recode(x = myData, A = 1 ~ V1 \%in\% c("A", "B"), 2 ~ "V2" == 3, "C" = 999 ~ V2 == -9)

}
