% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_data}
\alias{process_data}
\title{Data Pre-Processor}
\usage{
process_data(data, id, timestamp, glu, time_parser = as.POSIXct)
}
\arguments{
\item{data}{User-supplied dataset containing continuous glucose monitor data. Must
contain data for time and glucose readings at a minimum. Accepted formats are dataframe and tibble.}

\item{id}{Optional column name (character string) corresponding to subject id column.
If no value is passed, an id of 1 will be assigned to the data.}

\item{timestamp}{Required column name (character string) corresponding to time values in data. The dates can be
in any format parsable by as.POSIXct, or any format accepted by the parser passed to time_parser. See time_parser param for an explanation
on how to handle arbitrary formats.}

\item{glu}{Required column name (character string) corresponding to glucose values, mg/dL}

\item{time_parser}{Optional function used to convert datetime strings to time objects. Defaults to as.POSIXct.
If your times are in a format not parsable by as.POSIXct, you can parse a custom format by passing
function(time_string) \{strptime(time_string, format = <format string>)\} as the time_parser parameter.}
}
\value{
A processed DataFrame object that cooperates with every other
function within the \code{iglu} package - all column names and formats comply.
}
\description{
A helper function to assist in pre-processing the user-supplied
input data for use with other functions.
Typically, this function will process the data and return another DataFrame.
This function ensures that the returned data will be compatible with every
function within the \code{iglu} package. All \code{NA}s will be removed. See Vignette for further details.
}
\details{
A dataframe with the columns "id", "time", and "gl" will be returned. All \code{NA}s will be removed.

If "mmol/l" in the glucose column name, the glucose values will be multipled by 18 to convert to mg/dL.

Based on John Schwenck's \code{data_process} for his bp package "https://github.com/johnschwenck/bp".
}
\examples{
data("example_data_1_subject")

# Process example data
processed <- process_data(example_data_1_subject, id = "id", timestamp = "time", glu = "gl")

processed

data("example_data_5_subject")

# Process example data
processed_5subj <- process_data(example_data_5_subject, id = "id", timestamp = "time", glu = "gl")

processed_5subj

}
\author{
David Buchanan, John Schwenck
}
