#' US DOE/NNSA and DoD Response to 2011 Fukushima Incident: Radiological Soil Samples
#'
#' A table containing data after the radiation leaks from the nuclear power
#' plants in Japan.
#'
#'
#'
#' @format A data.table data frame with 2,032 rows and 25 variables:
#' \describe{
#' \item{Analysis Id}{Identification for the analysis}
#' \item{Sample Id}{Identification for the sample}
#' \item{Sample#}{Sample number}
#' \item{Type}{Source of sample}
#' \item{Fixed?}{Is the type fixed?}
#' \item{Latitude}{Latitude for the sample location}
#' \item{Longitude}{Longitude for the sample location}
#' \item{Distance(miles)}{Distance in miles}
#' \item{Bearing}{Bearing for the location}
#' \item{Direction}{Direction for the location}
#' \item{Collection Date}{Date of collection}
#' \item{Source}{Source}
#' \item{Description}{Description}
#' \item{Weight}{Filter type}
#' \item{Weight Unit}{Volume}
#' \item{Depth}{Unit of measurement for volume}
#' \item{Surface Area(cm2)}{Volume}
#' \item{Shape}{Unit of measurement for volume}
#' \item{Uncertainty\%}{Percent of uncertainty}
#' \item{MDA}{MDA}
#' \item{Method Code}{Method code}
#' \item{Moisture\%}{Moisture percent}
#' \item{Nuclide}{Nuclide}
#' \item{Result}{Result}
#' \item{Unit}{Unit for the result}
#' }
#'
#'
#' @source
#' United States (US) Department of Energy (DOE)/National Nuclear Security Administration (NNSA), "US DOE/NNSA and DoD Response to 2011 Fukushima Incident: Radiological Soil Samples", \url{https://web.archive.org/web/20160617000359/https://catalog.data.gov/dataset/us-doe-nnsa-and-dod-response-to-2011-fukushima-incident-radiological-soil-samples-ff220}. Retrieved thanks to the Internet Archive: Wayback Machine
#'
#' 
#'
#'
"Fukushima_2011_FieldSampleSoilResults_2"
#> [1] "Fukushima_2011_FieldSampleSoilResults_2"
