% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{iscolumn}
\alias{iscolumn}
\title{Column Vector (GNU Octave/MATLAB compatible)}
\usage{
iscolumn(x)
}
\arguments{
\item{x}{An array (array, matrix, vector)}
}
\value{
"Return true if x is a column vector. A column vector is a 2-D array
  for which size (x) returns [N, 1] with non-negative N." Source: Eaton page
  68.
}
\description{
Test for column vector that is compatible with GNU Octave/MATLAB.
}
\examples{

library(iemisc)

# Examples

xxx <- ramify::mat("1, 2"); xxx

iscolumn(xxx)








}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 68.
}
\seealso{
\code{\link{isrow}}
}
\author{
Irucka Embry, Rik Wehbring (GNU Octave), Colin B. Macdonald (OctSymPy)
}
