% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/air_stripper.R
\encoding{UTF-8}
\name{air_stripper}
\alias{air_stripper}
\title{Design of Packed Column Air Strippers}
\usage{
air_stripper(
  Temp,
  pTe,
  contam1,
  Cai,
  Cae,
  contam2,
  cas = NULL,
  Ha,
  Q,
  loading,
  ns,
  DL,
  DG,
  R,
  P_atm = NULL,
  dP = NULL,
  at = NULL,
  Sc = NULL,
  cf = NULL,
  Temp_unit = c("SI", "Eng", "Absolute"),
  dP_unit = c("inch", "mm"),
  at_unit = c("ft^2/ft^3", "m^2/m^3"),
  Sc_unit = c("kg/s^2", "slug/s^2"),
  contaminants_table = c(0, 1),
  removal_requirements_table = c(0, 1),
  critical_contaminant_table = c(0, 1)
)
}
\arguments{
\item{Temp}{numeric vector that contains the minimum Temperature (degrees
Celsius, degrees Fahrenheit, or Kelvin)}

\item{pTe}{numeric vector that contains the total pressure of gas (air)
effluent (atm)}

\item{contam1}{character vector that contains the name of each contaminant
to be removed (may include "Total VOCs"). See the example.}

\item{Cai}{numeric vector that contains the concentration of each
contaminant in liquid (water) influent (ug/L)}

\item{Cae}{numeric vector that contains the concentration of each
contaminant in liquid (water) effluent (ug/L)}

\item{contam2}{character vector that contains the name of each contaminant
(will not include "Total VOCs"). See the example.}

\item{cas}{character vector that contains the CAS Number of each contaminant,
if known, otherwise it can be accessed internally}

\item{Ha}{numeric vector that contains the Ha (Henry's Law coefficient) at
the minimum Temperature \emph{T} for each contaminant (atm/mole/mole)}

\item{Q}{numeric vector that contains the sustained pumping rate (gallons
per minute or gpm)}

\item{loading}{numeric vector that contains the stripper surface loading
(gpm/ft^2)}

\item{ns}{numeric vector that contains the number of strippers}

\item{DL}{numeric vector that contains the liquid diffusivity of each
contaminant at the minimum Temperature \emph{T} in the same order as
contam2 (m^2/s)}

\item{DG}{numeric vector that contains the gas diffusivity of each
contaminant in air at the minimum Temperature \emph{T} and \emph{pTe} in
the same order as contam2 (m^2/s)}

\item{R}{numeric vector that contains the stripping factor (R = 2.5 if air
pollution control is required or R = 4.5 if it isn't, but in a range of 2
- 5)}

\item{P_atm}{numeric vector that contains the atmospheric pressure (atm).
The default is 1 atm.}

\item{dP}{numeric vector that contains the nominal diameters for the packing
material. The Design Guidelines use Jaeger Tripacks 2-in. (50.8 mm) plastic
media for the packing material.}

\item{at}{numeric vector that contains the total surface area for the
packing material (the default value is 157 m^2/m^3)}

\item{Sc}{numeric vector that contains the critical surface tension for the
packing material (the default value is 0.033 kg/s^2)}

\item{cf}{numeric vector that contains the packing factor for the packing
material (the default value is 15/ft)}

\item{Temp_unit}{character vector that contains the possible units for the
water temperature {options are \code{SI} for International System of Units,
\code{Eng} for English units (United States Customary System in the United
States and Imperial Units in the United Kingdom), or \code{Absolute} for
Absolute Units}}

\item{dP_unit}{character vector that contains the possible units for the
nominal diameters for the packing material (inch or mm)}

\item{at_unit}{character vector that contains the possible units for the
total surface area for the packing material (ft^2/ft^3 or m^2/m^3)}

\item{Sc_unit}{character vector that contains the possible units for the
critical surface tension for the packing material (kg/s^2 or slug/s^2)}

\item{contaminants_table}{integer vector that contains 0, 1 only. 0 represents
do not print the Contaminants Table and 1 is for printing the Contaminants
Table.}

\item{removal_requirements_table}{integer vector that contains 0, 1 only. 0
represents do not print the Removal Requirements Table and 1 is for printing
the Removal Requirements Table.}

\item{critical_contaminant_table}{integer vector that contains 0, 1 only. 0
represents do not print the Critical Contaminant Table and 1 is for printing
the Critical Contaminant Table.}
}
\value{
the name of the critical contaminant, molar liquid (water) flow per
  unit of stripper cross-sectional area (kg mole/m^2 s), molar gas (air)
  flow per unit of stripper cross-sectional area (kg mole/m^2 s), height of
  transfer unit (HTU) [m and ft], number of transfer units (NTU), packing
  depth (m and feet), and the air to water ratio as a \code{\link[data.table]{data.table}}.
  If contaminants_table = 1, provide the Contaminants Table. If
  removal_requirements_table = 1, provide the Removal Requirements Table. If
  critical_contaminant_table = 1, provide the Critical Contaminant Table.
}
\description{
Calculates key parameters needed in the design of a packed column air
stripper according to the U.S. Army Corps of Engineers Design Guide No.
1110-1-3: Air Stripping Engineering and Design {Design Guidelines}. Please
refer to the Design Guidelines for the governing equations and background
information.

'Air stripping is the transferring of volatile components of a liquid into
an air stream. It is an environmental engineering technology used for the
purification of groundwaters and wastewaters containing volatile compounds.'
(Reference: Wikipedia)
}
\note{
Please Note: Use these results as preliminary estimates only.

Please Note: This is not meant for any actual designs.

Please Note: The calculations assume dry air rather than humid air.

Please refer to the iemisc: Air Stripping By Packed Column Examples vignette
for examples
}
\references{
\enumerate{
   \item Accu Dyne Test: Diversified Enterprises. Critical Surface Tension and Contact Angle with Water for Various Polymers, \url{https://www.accudynetest.com/polytable_03.html}.
   \item Design Guide No. 1110-1-3: Air Stripping Engineering and Design Appendix D: Example Air Stripping By Packed Column, Department Of The Army U.S. Army Corps of Engineers, 31 October 2001, pages D-1 - D-18, \url{https://www.publications.usace.army.mil/Portals/76/Publications/EngineerDesignGuides/DG_1110-1-3.pdf?ver=2013-08-16-101222-003}.
   \item Edgar L Andreas, Design Guide No. 1110-1-3: Handbook of Physical Constants and Functions for Use in Atmospheric Boundary Layer Studies, Department Of The Army U.S. Army Corps of Engineers, October 2005, pages D-1 - D-18, \url{https://apps.dtic.mil/sti/pdfs/ADA440352.pdf}.
   \item EnggCyclopedia. Tutorial: air density calculation, 3 January 2022, \url{https://enggcyclopedia.com/2019/04/air-density-calculation/}.
   \item Harlan H. Bengtson, PhD, P.E. Continuing Education and Development, Inc., Calculation of Gas Density and Viscosity Course No: H02-008, \url{https://www.scribd.com/document/452763833/Calculation-of-Gas-Density-and-Viscosity-pdf}.
   \item PCA Series Packed Column Air Strippers, H2K Technologies, Inc., 2011, page 2, \url{http://www.h2ktech.com/pdf_downloads/PCA_Packed_Column_Air_Strippers.pdf}.
   \item Peter J. Mohr, David B. Newell, and Barry N. Taylor. Continuing Education and Development, Inc., CODATA recommended values of the fundamental physical constants: 2014, \emph{Reviews Of Modern Physics}, Volume 88, July-September 2016, \url{https://physics.nist.gov/cuu/pdf/CODATA_JPCRD2016.pdf}.
   \item The NIST Reference on Constants, Units, and Uncertainty, Fundamental Constants Data Center of the NIST Physical Measurement Laboratory, "standard acceleration of gravity g_n", \url{https://physics.nist.gov/cgi-bin/cuu/Value?gn}.
   \item Wikimedia Foundation, Inc. Wikipedia, 27 March 2022, "Air stripping", \url{https://en.wikipedia.org/wiki/Air_stripping}.
}
}
\author{
Irucka Embry
}
