% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.dstm}
\alias{predict.dstm}
\title{Predict Method for DSTM Fits}
\usage{
\method{predict}{dstm}(
  object,
  K = 1,
  only_K = FALSE,
  return_ys = TRUE,
  return_thetas = FALSE,
  burnin = NULL,
  ...
)
}
\arguments{
\item{object}{A `dstm` object}

\item{K}{(integer scalar) The number of future time periods for which to generate
predictions}

\item{only_K}{(logical scalar) Whether to return predictions for time period T+K only
(as opposed to T+1, T+2, ..., T+K)}

\item{return_ys}{(logical scalar) Whether to return samples from the posterior predictive
distribution of the observation vector (ys)}

\item{return_thetas}{(logical scalar) Whether to return samples from the posterior predictive
distribution of the state vector (thetas)}

\item{burnin}{(integer scalar) The number of samples to discard as burn-in.
If object$burnin exists, this argument will override it.}

\item{...}{Arguments passed to other methods (necessary for 
S3 generic compatibility)}
}
\description{
Generates samples from the posterior predictive distribution 
at future time points for 
(1) the observation vector and (2) the state vector.
}
\details{
The posterior predictive samples are returned in a matrix or 3-D array,
depending on whether samples from multiple time points are requested.
The dimensions are always in the following order:

1. The index of the value within the state or observation vector.

2. The time period

3. The sample number
}
\examples{
data("ide_standard", "ide_locations")

# IDE example
mod_ide <- dstm_ide(ide_standard, ide_locations)
predict(mod_ide)
predict(mod_ide, K=4, return_thetas=TRUE)

# EOF example
mod_eof <- dstm_eof(ide_standard, n_samples=2)
predict(mod_eof, K=2, only_K=TRUE, burnin=1)
}
