% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{get.bs.all}
\alias{get.bs.all}
\title{Boostrap analysis}
\usage{
get.bs.all(n.boot, data.all, lst.var, deltas = 0, quantiles = 0.5,
  n.cores = 1, update.progress = NULL, ...)
}
\arguments{
\item{n.boot}{Number of bootstrap samples}

\item{data.all}{Original dataset}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{deltas}{Vector of imputation sensitivity parameters}

\item{quantiles}{Quantiles of the composite endpoint to be reported}

\item{n.cores}{Number of cores for parallel computation}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{...}{parameters for imputation. See \code{\link{get.imp.all}}}
}
\value{
A class \code{IDEM.BOOT} list
}
\description{
Boostrap analysis
}
\examples{

\dontrun{
lst.var  <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                 endp=c("Y2"), unitTime="days",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.boot <- get.bs.all(n.boot = 10, n.cores = 5, data.all = abc, lst.var = lst.var,
                       deltas = c(-0.25, 0, 0.25), quantiles = c(0.25,0.5,0.75),
                       normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);}

}

