% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{importance.icrf}
\alias{importance.icrf}
\alias{importance}
\alias{importance.default}
\title{'Extract variable importance measure'}
\usage{
importance(x, ...)

\method{importance}{default}(x, ...)

\method{importance}{icrf}(x, type = NULL, ...)
}
\arguments{
\item{x}{'an object of class' \code{icrf}}

\item{...}{'not used'}

\item{type}{either 1, 2, 3, or any combination of them, 'specifying the type of importance measure'
(1 = mean increase in IMSE1, 2 = mean increase in IMSE2, 3 = mean decrease in node impurity).
If not specified, all available types of importances are returned.}
}
\value{
An array of importance measure matrices, one row for each predictor variable.' Each column
corresponds to the forest iteration. Each matrix corresponds to the type of the measure.
}
\description{
'This is the extractor function for variable importance measures as produced by' \code{icrf}.
(Quoted statements are from
\code{randomForest} by Liaw and Wiener unless otherwise mentioned.)
}
\details{
'Here are the definitions of the variable importance measures. The first two measures are
computed from permuting OOB data: For each tree, the prediction error
on the out-of-bag portion of the data is recorded' (IMSE1 and IMSE2).
'Then the same is done after permuting each predictor variable.'
'The difference between the two are then averaged over all trees'
The normalization by the standard deviation of the differences is not supported in this version.
The third measure 'is the total decrease in node impurities from splitting on the variable,
averaged over all trees.'
'For regression, it is measured by residual sum of squares.'
}
\examples{
# rats data example.
# Note that this is a toy example. Use a larger ntree and nfold in practice.
data(rat2)
\donttest{
set.seed(1)
rats.icrf <-
  icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
       data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
       returnBest = TRUE, ntree=10, nfold=3)
importance(rats.icrf)
}
\dontshow{
set.seed(1)
rats.icrf <-
  icrf(~ dose.lvl + weight + male + cage.no, data = rat2,
       data.type = "currentstatus", currentstatus.label = c("survtime", "tumor"),
       returnBest = TRUE, ntree=2, nfold=2)
importance(rats.icrf)
}

}
\seealso{
\code{icrf}, \code{varImpPlot}
}
\author{
Hunyong Cho, Nicholas P. Jewell, and Michael R. Kosorok.

\href{https://arxiv.org/abs/1912.09983}{Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forests"}
}
