% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive.R
\name{archive}
\alias{archive}
\title{Read/write Objects <> Archive Files with Data Verification}
\usage{
archive(..., object, file)
}
\arguments{
\item{...}{unnamed arguments will be parsed as 'file' if there is only one
argument, 'object' and 'file' if there are two arguments.}

\item{object}{(for write operations) an object.}

\item{file}{the name of the file or a connection where the object is saved to
or read from.}
}
\value{
For read operations: the object originally archived.

    For write operations: the filename supplied. 'object' is written to 'file'.
}
\description{
Read and write objects to/from archival storage in the native RData format,
    with verification of data integrity.
}
\details{
For read operations: specify only 'file', or alternatively if no
    arguments are specified, a system dialog will be opened allowing a file
    to be chosen interactively. 'file' is read and the return value may be
    assigned to an object. A confirmation message is issued if the file read
    operation has been successful.

    For write operations: specify both 'object' and 'file'. If only 'object'
    is specified and 'file' is left empty (see examples), a system dialog
    will be opened allowing the file save location to be chosen interactively.
    'object' will be written to 'file'. A confirmation message is issued if
    the file write operation has been successful.
}
\section{Data Verification}{


    A SHA3-256 hash of the original object is written to the archive. This
    allows the data integrity of the restored object to be verified when the
    archive is read back.

    For write operations: confirmation of the SHA3-256 hash written to file
    is displayed.

    For read operations: a 'data verified' message is issued if the SHA256
    hash found within the data file has been authenticated.
}

\section{Further Details}{

    Please refer to the reference vignette by calling:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
file <- tempfile()

archive(cloud, file)

restored <- archive(file)

unlink(file)

if (interactive()) {
# Only run examples in interactive R sessions
# Read file to 'object' using system dialog:
object <- archive()

# Write 'cloud' to file using system dialog:
archive(cloud, )
}

}
