cloud <- ichimoku(sample_ohlc_data, ticker = "TKR", periods = c(9, 26, 52))

test_that("ichimoku object classes correct", {
  expect_s3_class(cloud, "ichimoku")
  expect_s3_class(cloud, "xts")
  expect_s3_class(cloud, "zoo")
})

test_that("ichimoku methods correct", {
  expect_s3_class(ichimoku(xts(sample_ohlc_data[, -1],
                                         order.by = sample_ohlc_data[, 1])), "ichimoku")
  expect_s3_class(ichimoku(as.matrix(xts(sample_ohlc_data[, -1],
                                       order.by = sample_ohlc_data[, 1]))), "ichimoku")
  expect_identical(cloud, ichimoku(cloud))
})

test_that("ichimoku object specification ok", {
  expect_true(dim(cloud)[2L] == 12)
})

test_that("ichimoku error handling ok", {
  expect_error(ichimoku(autoplot(cloud)), regexp = "ichimoku object")
  expect_error(ichimoku(nonexistent, regexp = "not found"))
  expect_error(ichimoku("nonexistent", regexp = "not found"))
  expect_error(ichimoku(), regexp = "No object")
  expect_error(ichimoku(data.frame(time = 1:10)), regexp = "not convertible")
  expect_error(ichimoku(sample_ohlc_data[-1]), regexp = "Valid date-time")
  expect_error(ichimoku(sample_ohlc_data[, -3]), regexp = "columns not found")
  expect_error(ichimoku(sample_ohlc_data[1,]), regexp = "longer than")
  expect_warning(ichimoku(sample_ohlc_data, periods = c(8, 15)), regexp = "cloud periods invalid")
  expect_warning(ichimoku(sample_ohlc_data[, -2]), regexp = "Opening prices")
})

test_that("ichimoku plot functions ok", {
  expect_s3_class(autoplot(cloud, ticker = "TKR Co.", theme = "solarized"), "ggplot")
  expect_s3_class(plot(strat(cloud), window = "2020-06"), "ggplot")
  expect_s3_class(gplot(cloud, window = "2020-06", message = "m", theme = "mono"), "ggplot")
})

test_that("iplot Shiny functions ok", {
  skip_if_not_installed("shiny")
  expect_s3_class(iplot(cloud, theme = "dark"), "shiny.appobj")
  expect_error(iplot(sample_ohlc_data), regexp = "ichimoku object")
  shiny::testServer(iplot(cloud), {
    session$setInputs(plot_hover = list(x = 2, y = 125, coords_css = list(x = 200, y = 200)))
    expect_s3_class(pdata(), "ichimoku")
  })
  expect_s3_class(drawInfotip(sdata = cloud[100,], left_px = 100, top_px = 100), "shiny.tag")
  expect_s3_class(drawGuide(label = index(cloud)[1], left = 100, top = 100), "shiny.tag")
})

test_that("is.ichimoku ok", {
  expect_true(is.ichimoku(cloud))
  expect_false(is.ichimoku(sample_ohlc_data))
})

test_that("print.ichimoku print method ok", {
  expect_s3_class(print(cloud), "ichimoku")
  expect_s3_class(print(cloud, plot = FALSE), "ichimoku")
})
