% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{matrix_df}
\alias{matrix_df}
\title{Convert matrix to data.frame}
\usage{
matrix_df(x)
}
\arguments{
\item{x}{a matrix.}
}
\value{
A 'data.frame' object.
}
\description{
A performant 'matrix' to 'data.frame' constructor with no data validation or
    checking.
}
\details{
Designed for working with time series data where the date-time index
    is contained in the row names of the matrix.

    Note: the function only works with matrices containing row names, as these
    are preserved in the data frame. If the row names are null, the 'data.frame'
    object is still created but will display as having zero rows. This can be
    fixed by appending an index value to the row names of the resultant object:
    \code{row.names(x) <- 1:nrow(x)}.
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
mcloud <- as.matrix(cloud)
df <- matrix_df(mcloud)
str(df)
str(rownames(df))

}
