# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Maximum Over a Rolling Window
#'
#' Used by \link{ichimoku} to calculate the maximum over a rolling window.
#'
#' @param x a vector.
#' @param window size of the rolling window.
#'
#' @return A vector of the same length as 'x' with elements 1 to
#'     (length(window) - 1) containing NAs.
#'
#' @details Fast implementation with no error checking or NA handling.
#'
#' @examples
#' maxOver(sample_ohlc_data$close[1:10], 3L)
#'
#' @export
maxOver <- function(x, window) {
    .Call(`_ichimoku_maxOver`, x, window)
}

#' Minimum Over a Rolling Window
#'
#' Used by \link{ichimoku} to calculate the minimum over a rolling window.
#'
#' @param x a vector.
#' @param window size of the rolling window.
#'
#' @return A vector of the same length as 'x' with elements 1 to
#'     (length(window) - 1) containing NAs.
#'
#' @details Fast implementation with no error checking or NA handling.
#'
#' @examples
#' minOver(sample_ohlc_data$close[1:10], 3L)
#'
#' @export
minOver <- function(x, window) {
    .Call(`_ichimoku_minOver`, x, window)
}

