% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkCodes.R
\name{linkCodes}
\alias{linkCodes}
\title{Get Links Between Two Code Types}
\usage{
linkCodes(code_type, linked_code_type, codes = NULL, ...)
}
\arguments{
\item{code_type}{an ICES Vocabulary code type.}

\item{linked_code_type}{another ICES Vocabulary code type.}

\item{codes}{a vector of codes to restrict the output to.}

\item{...}{for back compatibility.}
}
\value{
A data frame.
}
\description{
Find parent or child linkages between the codes of two code types.
}
\examples{
\dontrun{
x <- linkCodes("Pargroup", "PARAM")
# note it is much faster to use:
# getCodeTypeRelation("Pargroup", "PARAM")
# when getting a full lookup table.

# get all areas for cod.27.1-2
linkCodes("ICES_StockCode", "ICES_Area", codes = c("cod.27.1-2"))

# get areas for cod.27.21, cod.27.24-32 and cod.27.46a7d20
linkCodes("ICES_StockCode", "ICES_Area", codes = c("cod.27.21", "cod.27.24-32", "cod.27.46a7d20"))
}
}
\seealso{
\code{\link{icesVocab-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
