% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodeTypeList.R
\name{getCodeTypeList}
\alias{getCodeTypeList}
\title{Get Types}
\usage{
getCodeTypeList(code_type = NULL, date = NULL)
}
\arguments{
\item{code_type}{optional parameter to restrict output to a specific code type.}

\item{date}{restrict output to code types modified after a given date in
yyyy-mm-dd format, e.g. "2010-12-01"}
}
\value{
A data frame.
}
\description{
Get all code types. Mainly useful as a reminder of what code types are
available.
}
\examples{
\dontrun{
# Find code type for World Register of Marine Species (WoRMS)
types <- getCodeTypeList()
types[grep("worms", tolower(types$Description)),]

# The code type "SpecWoRMS" can be used when calling getCodeTypeList()
getCodeTypeList(code_type = "SpecWoRMS")
# or using the guid
getCodeTypeList(code_type = "f107b677-97ff-4cd9-b4ab-637bb6706066")

findCodeType("worms", full = TRUE)

}
}
\seealso{
\code{\link{getCodeList}} and \code{\link{getCodeDetail}} get codes of a
given type and code details.

\code{\link{findCodeType}} searches for a code types based on a search string.

\code{\link{icesVocab-package}} gives an overview of the package.
}
