% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.data.script.R
\name{add.data.script}
\alias{add.data.script}
\title{Import a bootstrap data script from ICES datasets repo}
\usage{
add.data.script(name, install.deps = TRUE, commit = FALSE)
}
\arguments{
\item{name}{the name of the dataset.}

\item{install.deps}{install packages used in the script if not already
installed.}

\item{commit}{should the bootstrap file be added and committed to the
analysis.}
}
\description{
Download an \file{R} file from the ICES datasets repo to fetch
data including adding metadata via roxygen2 fields to the top of the file.
}
\examples{
\dontrun{

# Create bootstrap folder
mkdir(taf.boot.path())

# Create bootstrap script, bootstrap/mydata.R
add.data.script(name = "vms")

# Create metadata, bootstrap/DATA.bib
taf.roxygenise(files = "vms.R")

# Run bootstrap script, creating bootstrap/data/vms/...
taf.bootstrap()
}

}
