% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAGxml.R
\name{stockInfo}
\alias{stockInfo}
\title{Create a list of fish stock information}
\usage{
stockInfo(StockCode, AssessmentYear, ContactPerson, ...)
}
\arguments{
\item{StockCode}{a stock name, e.g. cod-347d.}

\item{AssessmentYear}{the assessment year, e.g. 2015.}

\item{ContactPerson}{the email for the person responsible for uploading the stock data.}

\item{...}{additional information, e.g. BMGT, FMSY, RecruitmentAge, ...}
}
\value{
A named sag.list, inheriting from a list, where all names are valid column names in the
        SAG database.
}
\description{
This function is a wrapper to \code{list(...)} in which the names are forced to match with
the names required for the SAG database.  See http://dome.ices.dk/datsu/selRep.aspx?Dataset=126
for more details.
}
\examples{
info <-
  stockInfo(StockCode = "cod.27.347d",
            AssessmentYear = 2017,
            ContactPerson = "itsme@fisheries.com")

 info
 info$mistake <- "oops"
 info
 # should have gotten a warning message
}
\author{
Colin Millar.
}
