% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9GetMajor}
\alias{icd9DecimalToMajor}
\alias{icd9GetMajor}
\alias{icd9ShortToMajor}
\title{extract major part from short or decimal ICD-9 code}
\usage{
icd9GetMajor(icd9, isShort, invalidAction = icd9InvalidActions)

icd9DecimalToMajor(icd9Decimal, invalidAction = icd9InvalidActions)

icd9ShortToMajor(icd9Short, invalidAction = icd9InvalidActions)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
character vector
}
\description{
Simply extracts parts, then returns only the major part in a
  character vector
}

