% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpanData.R
\name{ExpandData}
\alias{ExpandData}
\title{Expand branch abundance/incience and branch length}
\usage{
ExpandData(x, labels, phy, datatype = "abundance")
}
\arguments{
\item{x}{a vector/matrix/list of species abundances or a matrix of raw incidence table.\cr}

\item{labels}{a vector of species name for input data.\cr}

\item{phy}{a phylogenetic tree with \code{"phylog"} class.\cr}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}), species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}
}
\value{
a data.frame with sample size and sample coverage.
}
\description{
\code{ExpandData}: Expand branch abundance/incience and branch length
}
\examples{
data(bird)
bird.abu <- bird$abun
bird.inc <- bird$inci
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
ExpandData(bird.abu, labels=bird.lab, phy=bird.phy, datatype="abundance")
ExpandData(bird.inc, labels=bird.lab, phy=bird.phy, datatype="incidence_raw")
}

