% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_numeric.R
\name{filterNumeric}
\alias{filterNumeric}
\title{Filter data by levels of a numeric variables}
\usage{
filterNumeric(.data, var, op, num)
}
\arguments{
\item{.data}{a dataframe or survey design object to filter}

\item{var}{character of the column in \code{.data} to filter by}

\item{op}{a logical operator of "<=", "<", ">=", ">", "==" or "!="
for the boolean condition}

\item{num}{a number for which the \code{op} applies to}
}
\value{
filtered dataframe with tidyverse code attached
}
\description{
Filter a dataframe by some boolean condition of one numeric variable
and returns the result along with tidyverse code used to generate it.
}
\examples{
filtered <- filterNumeric(iris, var = "Sepal.Length", op = "<=", num = 5)
cat(code(filtered))
head(filtered)

require(survey)
data(api)
svy <- svydesign(~dnum+snum, weights = ~pw, fpc = ~fpc1+fpc2, data = apiclus2)
(svy_filtered <- filterNumeric(svy, var = "api00", op = "<", num = 700))
cat(code(svy_filtered))

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin, Tom Elliott
}
