% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummary.R, R/inzplot.R
\name{inzsummary}
\alias{inzsummary}
\alias{inzinference}
\alias{inzplot}
\alias{inzplot.formula}
\title{iNZight Plot Method}
\usage{
inzsummary(x, data = NULL, design = NULL, ..., env = parent.frame())

inzinference(
  x,
  data = NULL,
  design = NULL,
  type = c("conf", "comp"),
  ...,
  env = parent.frame()
)

inzplot(x, ..., env = parent.frame())

\method{inzplot}{formula}(x, data = NULL, design = NULL, ..., env = parent.frame())
}
\arguments{
\item{x}{A formula in the form of \code{y ~ x | g}. See Details.}

\item{data}{Dataset to plotq}

\item{design}{A survey design to use}

\item{...}{Any arguments to pass to \code{\link{iNZightPlot}}}

\item{env}{the parent environment to pass to the plot function}

\item{type}{Type type of inference to obtain, one of 'conf' or 'comp'
for confidence intervals and comparison intervals, respectively
(currently ignored).}
}
\value{
The output depends on the type of input, but is usually called for
        the side-effect of producing a plot.

An \code{inzightplotoutput} object, which contains the information
        displayed in the plot
}
\description{
A generic function used to plot objects within the iNZight ecosystem.
}
\details{
\code{inzplot} is a simple wrapper around the \code{\link{iNZightPlot}} function.

There are four options for the formula passed in:

\code{y} will produce a plot of the single variable \code{y}.

\code{y ~ x} will produce a plot of \code{y} against \code{x}.

\code{y ~ x | g1} will produce a plot of \code{y} against \code{x} subset by \code{g1}.

\code{y ~ x | g1 + g2} will produce a plot of \code{y} against \code{x} subset by \code{g1} and \code{g2}.
}
\section{Functions}{
\itemize{
\item \code{inzsummary}: Wrapper for getPlotSummary to obtain summary information about a plot

\item \code{inzinference}: Wrapper for getPlotSummary to obtain inference information about a plot
}}

\examples{
data("CO2")
inzplot(~uptake, data = CO2)
inzplot(uptake ~ Treatment, data = CO2)
inzplot(uptake ~ Treatment | Type, data = CO2)
inzplot(uptake ~ Treatment | Type,
data = CO2, g1.level = "Quebec")
}
\seealso{
iNZightPlot
}
