% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_values.R
\name{cldr_currencies}
\alias{cldr_currencies}
\title{Get a single localized value from the \link{currencies} dataset}
\usage{
cldr_currencies(
  locale = "en",
  currency = currency_code_list$USD,
  element = currencies_elements$currency_symbol
)
}
\arguments{
\item{locale}{The locale ID for which to obtain the data from the
\link{currencies} table.}

\item{currency}{The currency code (e.g., \code{"USD"}, \code{"EUR"}, etc.). A valid set
of currency codes can be accessed through the \link{currency_code_list} object.}

\item{element}{The element from which information will be obtained for the
specified \code{locale}. A valid set of currency elements can be accessed
through the \link{currencies_elements} list object.}
}
\value{
A length one character vector.
}
\description{
The \link{currencies} table contains information of currency codes and localized
display names and symbols across 571 locales. The
\code{cldr_currencies()} function allows one to extract a single element value
from the table by supplying the \code{locale}, the currency code (\code{currency}), and
one of the following \code{element} names:
\itemize{
\item \code{"currency_symbol"}
\item \code{"currency_symbol_narrow"}
\item \code{"currency_display_name"}
\item \code{"currency_display_name_count_1"}
\item \code{"currency_display_name_count_other"}
}
}
\section{Examples}{


If you would like to get the currency display name for the British Pound
(\code{"GBP"}) currency while in the \code{"de"} locale, the following invocation of
\code{cldr_currencies()} can be used.\if{html}{\out{<div class="sourceCode r">}}\preformatted{cldr_currencies(
  locale = "de",
  currency = currency_code_list$GBP,
  element = currencies_elements$currency_display_name
)
}\if{html}{\out{</div>}}\preformatted{#> [1] "Britisches Pfund"
}
}

