\name{hzar.chain.doSeq}
\alias{hzar.chain.doSeq}
\title{
  Repeatedly run the optimizer in series to tune the optimizer.

}
\description{
  \code{hzar.chain.doSeq} cyclically calls \code{\link{hzar.doFit}} and
  \code{\link{hzar.next.fitRequest}} in order to optimize the covariance
  matrix driving mcmc process, \code{\link{MCMCmetrop1R}}.
}
\usage{
hzar.chain.doSeq(hzar.request,
                 count = 3,
                 collapse = FALSE,
                 announce.complete = "Chain Complete")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{hzar.request}{
    The \code{\link{hzar.fitRequest}} object to use initially.
  }
  \item{count}{
    How many iterations to perform.
  }
  \item{collapse}{
    If TRUE, if all iterations succeed return a single
    \code{\link{hzar.fitRequest}} object with all of the results
    concatenated instead of a list of \code{\link{hzar.fitRequest}}
    objects.   
  }
  \item{announce.complete}{
    Diagnostics message to print when the chain has completed.
  }
}
\details{
  For each iteration, \code{\link{hzar.doFit}} is called using
  \code{hzar.request} and the result is added to the results list. 

  For the second and all subsequent iterations, \code{hzar.request} is
  generated by \code{\link{hzar.next.fitRequest}} using the results of
  the previous iteration. If \code{\link{hzar.next.fitRequest}} fails,
  the results list is returned.

  When \code{count} iterations are performed and if collapse is TRUE,
  the results list is reduced to a single \code{\link{hzar.fitRequest}}
  object with the covariance matrix set to the last matrix used.  All
  other fields are set as if the concatenated results were the results
  of a single call to \code{\link{hzar.doFit}}.
}
\value{
  Either a list of all successful \code{\link{hzar.fitRequest}} objects,
  or, if collapse is TRUE, a single \code{\link{hzar.fitRequest}} object
  with all of the results concatenated.
}

\author{
Graham Derryberry \email{asterion@alum.mit.edu}
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{hzar.fitRequest}}
  \code{\link{hzar.doFit}} 
  \code{\link{MCMCmetrop1R}}
  \code{\link{hzar.next.fitRequest}}
}
\examples{


data(manakinMolecular);
mknAdaA <-
  hzar.doMolecularData1DPops(manakinMolecular$distance,
                             manakinMolecular$ada.A,
                             manakinMolecular$ada.nSamples);
mknAdaAmodel <-
  hzar.makeCline1DFreq(mknAdaA, scaling="fixed",tails="none");
mknAdaAmodel <-
  hzar.model.addBoxReq(mknAdaAmodel, -30, 600)
mknAdaAmodelFit <-
  hzar.first.fitRequest.old.ML(model=mknAdaAmodel ,
                               mknAdaA,
                               verbose=FALSE);
mknAdaAmodelFit$mcmcParam$chainLength <- 1e3;
mknAdaAmodelFit$mcmcParam$burnin <- 50;
mknAdaAmodelFit$mcmcParam$thin <- 10;
str(hzar.chain.doSeq(mknAdaAmodelFit, count=2));

}
% % Add one or more standard keywords, see file 'KEYWORDS' in the
% % R documentation directory.
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
