% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPreciBar(generic).R
\name{getPreciBar_comb}
\alias{getPreciBar_comb}
\title{Combine bars together}
\usage{
getPreciBar_comb(..., list = NULL, nrow = 1, x = "", y = "",
  title = "", output = FALSE)
}
\arguments{
\item{...}{different barplots generated by \code{getPreciBar(, output = 'ggplot')}, refer to details.}

\item{list}{If input is a list containing different ggplot data, use l\code{list = inputlist}.
NOTE: yOU HAVE TO PUT A \code{list = }, before your list.}

\item{nrow}{A number showing the number of rows.}

\item{x}{A string of x axis name.}

\item{y}{A string of y axis name.}

\item{title}{A string of the title.}

\item{output}{A boolean, if chosen TRUE, the output will be given.}
}
\value{
A combined barplot.
}
\description{
Combine bars together
}
\details{
..., representing different ouput generated by \code{getPreciBar(, output = 'ggplot')}, they 
have to be of the same type, e.g., 
1. Jan precipitation of different years, Feb precipitation of different years, and... 
They are both monthly precipitation, and they share x axis.

2. Mean monthly precipitation of different dataset. e.g., long term mean monthly precipitation
and short term mean monthly precipitation. They are both mean monthly precipitation.
}
\examples{

data(tgridData)# the result of \\code{\\link{loadNcdf}}
#output type of getPreciBar() has to be 'ggplot'.
b1 <- getPreciBar(tgridData, method = 2, output = 'ggplot', name = 'b1')
b2 <- getPreciBar(tgridData, method = 3, output = 'ggplot', name = 'b2')

getPreciBar_comb(b1, b2)

# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
}
}
